/*
 * Decompiled with CFR 0.152.
 */
package mlsoft.mct;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import mlsoft.mct.MlSegment;

public class MlUtil {
    public static final int RECT_OUTSIDE = 0;
    public static final int RECT_INSIDE = 1;
    public static final int RECT_PARTIAL = 2;
    public static final int DRAW_NODRAW = 0;
    public static final int DRAW_NOCLIP = 1;
    public static final int DRAW_CLIPPED = 2;
    public static final int ALIGNMENT_LEFT = 0;
    public static final int ALIGNMENT_CENTER = 1;
    public static final int ALIGNMENT_RIGHT = 2;
    public static final int ALIGNMENT_TOP_LEFT = 3;
    public static final int ALIGNMENT_TOP = 4;
    public static final int ALIGNMENT_TOP_RIGHT = 5;
    public static final int ALIGNMENT_BOTTOM_LEFT = 6;
    public static final int ALIGNMENT_BOTTOM = 7;
    public static final int ALIGNMENT_BOTTOM_RIGHT = 8;
    public static final int WIN_TOOLKIT = 0;
    public static final int MOTIF_TOOLKIT = 1;
    public static final int OTHER_TOOLKIT = 2;
    static int _toolkitType = -1;

    protected static int calcDrawWrapText(Graphics graphics, Font font, String string, int n, Dimension dimension) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        FontMetrics fontMetrics = toolkit.getFontMetrics(font);
        int n2 = fontMetrics.getHeight();
        int n3 = fontMetrics.stringWidth(" ");
        int n4 = string.length();
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (n8 <= n4) {
            char c = '\u0000';
            if (n8 == n4 || (c = string.charAt(n8)) == ' ' || c == '\n') {
                if (n8 - n7 >= 1) {
                    String string2 = string.substring(n7, n8);
                    int n9 = fontMetrics.stringWidth(string2);
                    if (n5 + n9 >= dimension.width) {
                        n6 += n2;
                        n5 = 0;
                    }
                    if (graphics != null && n6 + n >= 0 && n6 + n < dimension.height) {
                        graphics.drawString(string2, n5, n6 + n2 + n);
                    }
                    n5 += n9;
                }
                if (c == '\n' || n8 == n4) {
                    n6 += n2;
                    n5 = 0;
                } else if (c == ' ') {
                    n5 += n3;
                }
                n7 = n8 + 1;
            }
            ++n8;
        }
        return n6 + fontMetrics.getMaxDescent();
    }

    protected static Rectangle copyRect(Rectangle rectangle) {
        return new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected static int drawCalcType(int n, int n2, Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle.width <= 4 || rectangle.height <= 4 || rectangle2.width < 3 || rectangle2.height < 3 || n == 0 || n2 == 0) {
            return 0;
        }
        int n3 = MlUtil.rectIntersect(rectangle, rectangle2);
        if (n3 == 0) {
            return 0;
        }
        if (n3 == 1 && n + 4 <= rectangle.width && n2 + 4 <= rectangle.height) {
            return 1;
        }
        return 2;
    }

    protected static Point drawCalcXY(int n, int n2, int n3, Rectangle rectangle) {
        int n4 = n3 == 3 || n3 == 0 || n3 == 6 ? rectangle.x + 2 : (n3 == 4 || n3 == 1 || n3 == 7 ? rectangle.x + (rectangle.width - n) / 2 : rectangle.x + rectangle.width - n - 2);
        int n5 = n3 == 4 || n3 == 3 || n3 == 5 ? rectangle.y + 2 : (n3 == 0 || n3 == 1 || n3 == 2 ? rectangle.y + (rectangle.height - n2) / 2 : rectangle.y + rectangle.height - n2 - 2);
        return new Point(n4, n5);
    }

    protected static void drawLines(Graphics graphics, Point[] pointArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            graphics.drawLine(pointArray[n2].x, pointArray[n2].y, pointArray[n2 + 1].x, pointArray[n2 + 1].y);
            ++n2;
        }
    }

    protected static void drawOption(Graphics graphics, boolean bl, int n, int n2, Color color, Color color2, Color color3, Color color4, Rectangle rectangle, Rectangle rectangle2) {
        if (n < 3) {
            return;
        }
        int n3 = MlUtil.drawCalcType(n, n, rectangle, rectangle2);
        if (n3 == 0) {
            return;
        }
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        Point point = MlUtil.drawCalcXY(n, n, n2, rectangle);
        int n4 = point.x;
        int n5 = point.y;
        if (n3 == 2) {
            graphics = graphics.create();
            MlUtil.graphicsClipRect(graphics, rectangle2);
        }
        graphics.setColor(color);
        graphics.fillRect(n4, n5, n, n);
        MlUtil.drawShadow(graphics, n4, n5, n, n, 2, color2, color3);
        nArray[0] = n4 + 4;
        nArray2[0] = n5 + 4;
        nArray[1] = n4 + n / 2;
        nArray2[1] = n5 + n - 5;
        nArray[2] = n4 + n - 5;
        nArray2[2] = n5 + 4;
        nArray[3] = n4 + 4;
        nArray2[3] = n5 + 4;
        graphics.setColor(color4);
        graphics.fillPolygon(nArray, nArray2, 4);
        int n6 = 0;
        while (n6 < 3) {
            graphics.drawLine(nArray[n6], nArray2[n6], nArray[n6 + 1], nArray2[n6 + 1]);
            ++n6;
        }
        if (n3 == 2) {
            graphics.dispose();
        }
    }

    protected static void drawSegments(Graphics graphics, MlSegment[] mlSegmentArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            graphics.drawLine(mlSegmentArray[n2].x1, mlSegmentArray[n2].y1, mlSegmentArray[n2].x2, mlSegmentArray[n2].y2);
            ++n2;
        }
    }

    protected static void drawToggle(Graphics graphics, boolean bl, int n, int n2, Color color, Color color2, Color color3, Color color4, Rectangle rectangle, Rectangle rectangle2) {
        if (n < 3) {
            return;
        }
        int n3 = MlUtil.drawCalcType(n, n, rectangle, rectangle2);
        if (n3 == 0) {
            return;
        }
        int[] nArray = new int[3];
        int[] nArray2 = new int[4];
        int[] nArray3 = new int[5];
        int[] nArray4 = new int[5];
        Point point = MlUtil.drawCalcXY(n, n, n2, rectangle);
        int n4 = point.x;
        int n5 = point.y;
        if (n3 == 2) {
            graphics = graphics.create();
            MlUtil.graphicsClipRect(graphics, rectangle2);
        }
        graphics.setColor(color);
        graphics.fillRect(n4, n5, n, n);
        MlUtil.drawShadow(graphics, n4, n5, n, n, 1, color2, color3);
        if (bl) {
            nArray[0] = n4 + 1;
            nArray[1] = n4 + (n - 3) / 3 + 1;
            nArray[2] = n4 + n - 2;
            nArray2[0] = n5 + 1;
            nArray2[1] = n5 + (n - 3) / 2 + 1;
            nArray2[2] = n5 + (n - 3) * 2 / 3 + 1;
            nArray2[3] = n5 + n - 2;
            nArray3[0] = nArray[0];
            nArray4[0] = nArray2[1];
            nArray3[1] = nArray[1];
            nArray4[1] = nArray2[3];
            nArray3[2] = nArray[2];
            nArray4[2] = nArray2[0];
            nArray3[3] = nArray[1];
            nArray4[3] = nArray2[2];
            nArray3[4] = nArray3[0];
            nArray4[4] = nArray4[0];
            graphics.setColor(color4);
            graphics.fillPolygon(nArray3, nArray4, 5);
            int n6 = 0;
            while (n6 < 4) {
                graphics.drawLine(nArray3[n6], nArray4[n6], nArray3[n6 + 1], nArray4[n6 + 1]);
                ++n6;
            }
        }
        if (n3 == 2) {
            graphics.dispose();
        }
    }

    protected static void fillPolygon(Graphics graphics, Point[] pointArray, int n) {
        if (n == 0) {
            return;
        }
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = pointArray[n2].x;
            nArray2[n2] = pointArray[n2].y;
            ++n2;
        }
        graphics.fillPolygon(nArray, nArray2, n);
    }

    protected static int getToolkitType() {
        if (_toolkitType == -1) {
            String string = Toolkit.getDefaultToolkit().getClass().toString();
            _toolkitType = string.indexOf("win") != -1 ? 0 : (string.indexOf("otif") != -1 ? 1 : 2);
        }
        return _toolkitType;
    }

    protected static void graphicsClipRect(Graphics graphics, Rectangle rectangle) {
        Color color = graphics.getColor();
        graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(color);
    }

    public static int calcWrapTextHeight(Font font, String string, int n) {
        if (font == null || string == null || n <= 0) {
            return 0;
        }
        return MlUtil.calcDrawWrapText(null, font, string, 0, new Dimension(n, 0));
    }

    public static void drawImage(Graphics graphics, Image image, ImageObserver imageObserver, int n, int n2, int n3, Rectangle rectangle, Rectangle rectangle2) {
        int n4;
        if (image == null) {
            return;
        }
        int n5 = n;
        int n6 = n2;
        if (n5 == 0 || n6 == 0) {
            n3 = 3;
            n5 = rectangle2.width - 4;
            n6 = rectangle2.height - 4;
        }
        if ((n4 = MlUtil.drawCalcType(n5, n6, rectangle, rectangle2)) == 0) {
            return;
        }
        Point point = MlUtil.drawCalcXY(n5, n6, n3, rectangle);
        int n7 = point.x;
        int n8 = point.y;
        if (n4 == 2) {
            graphics = graphics.create();
            MlUtil.graphicsClipRect(graphics, rectangle2);
        }
        graphics.drawImage(image, n7, n8, imageObserver);
        if (n4 == 2) {
            graphics.dispose();
        }
    }

    public static void drawShadow(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, Color color2) {
        int n6 = n + n3 - 1;
        int n7 = n2 + n4 - 1;
        graphics.setColor(color);
        int n8 = 0;
        while (n8 < n5) {
            graphics.drawLine(n6 - n8, n2 + n8, n + n8, n2 + n8);
            graphics.drawLine(n + n8, n2 + n8, n + n8, n7 - n8);
            ++n8;
        }
        graphics.setColor(color2);
        n8 = 0;
        while (n8 < n5) {
            graphics.drawLine(n + n8, n7 - n8, n6 - n8, n7 - n8);
            graphics.drawLine(n6 - n8, n7 - n8, n6 - n8, n2 + n8);
            ++n8;
        }
    }

    public static void drawString(Graphics graphics, String string, Font font, int n, Rectangle rectangle, Rectangle rectangle2) {
        if (font == null || string == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n2 = fontMetrics.getHeight();
        int n3 = fontMetrics.stringWidth(string);
        int n4 = MlUtil.drawCalcType(n3, n2, rectangle, rectangle2);
        if (n4 == 0) {
            return;
        }
        Point point = MlUtil.drawCalcXY(n3, n2, n, rectangle);
        int n5 = point.x;
        int n6 = point.y;
        graphics = graphics.create();
        if (n4 == 2) {
            MlUtil.graphicsClipRect(graphics, rectangle2);
        }
        graphics.setFont(font);
        graphics.drawString(string, n5, n6 + fontMetrics.getAscent());
        graphics.dispose();
    }

    public static void drawWrapText(Graphics graphics, Font font, String string, int n, Dimension dimension) {
        if (graphics == null || font == null || string == null || dimension.width <= 0 || dimension.height <= 0) {
            return;
        }
        MlUtil.calcDrawWrapText(graphics, font, string, n, dimension);
    }

    public static Dimension getFontDimensions(Font font, boolean bl) {
        if (font == null) {
            System.out.println("fontDimensions() pass null font - using default (10, 12)");
            return new Dimension(10, 12);
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        FontMetrics fontMetrics = toolkit.getFontMetrics(font);
        if (fontMetrics == null) {
            System.out.println("getFontMetrics() returned null using default (10, 12)");
            return new Dimension(10, 12);
        }
        int[] nArray = fontMetrics.getWidths();
        int n = 0;
        int n2 = 0;
        while (n2 < 256) {
            if (!bl) {
                if (nArray[n2] > n) {
                    n = nArray[n2];
                }
            } else {
                n += nArray[n2];
            }
            ++n2;
        }
        if (bl) {
            n = n / 256 + 1;
        }
        return new Dimension(n, fontMetrics.getHeight());
    }

    public static Dimension getImageDimensions(Image image, ImageObserver imageObserver) {
        int n = image.getWidth(imageObserver);
        int n2 = image.getHeight(imageObserver);
        if ((n < 0 || n2 < 0) && imageObserver instanceof Component) {
            Component component = (Component)imageObserver;
            MediaTracker mediaTracker = new MediaTracker(component);
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForAll();
            }
            catch (Exception exception) {}
            n = image.getWidth(imageObserver);
            n2 = image.getHeight(imageObserver);
        }
        return new Dimension(n, n2);
    }

    public static int rectIntersect(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle.width == 0 || rectangle.height == 0 || rectangle2.width == 0 || rectangle2.height == 0) {
            return 0;
        }
        if (rectangle.x + rectangle.width - 1 < rectangle2.x || rectangle.x > rectangle2.x + rectangle2.width - 1 || rectangle.y + rectangle.height - 1 < rectangle2.y || rectangle.y > rectangle2.y + rectangle2.height - 1) {
            return 0;
        }
        if (rectangle.x >= rectangle2.x && rectangle.x + rectangle.width <= rectangle2.x + rectangle2.width && rectangle.y >= rectangle2.y && rectangle.y + rectangle.height <= rectangle2.y + rectangle2.height) {
            return 1;
        }
        return 2;
    }

    public static int version() {
        return 310;
    }
}

